save_file = ""

global verts
global faces
global tverts
global nVerts
global nFaces
global nTVerts
global objname
global normals

fn rtoken str = (
		ret_string = filterString str " :,\""
		return ret_string[1]
)

fn createobj =(
	if (tverts.count > 0) then (
		m = mesh vertices:verts faces:faces tverts:tverts
		update m
		setnumtverts m tverts.count true
		buildTVfaces m
		for j = 1 to tverts.count do settvert m j tverts[j]
		for i = 1 to faces.count do settvface m i faces[i]
		update m
	) else (
		m = mesh vertices:verts faces:faces
	)

	if normals[1] != undefined then (
		for i = 1 to faces.count do (
				setfacesmoothgroup m i (normals[i])
		)
	) else (
		addmodifier m (smooth autosmooth:true threshhold:45)
		collapsestack m
	)
		
	update (m)
	m.name = uniquename(objname)
	
	format "verts: %\ntverts: %\nfaces: %\n" (verts.count) (tverts.count) (faces.count)
)

fn fn_import=(
	filename = getOpenFileName "Import OBJ" types:"Wavefront OBJ (*.obj)|*.obj|All Files (*.*)|*.*"
	
	if filename != undefined then	(
		fp = openFile filename
		
		verts = #()
		faces = #()
		tverts = #()
		normals = #()
		nVerts = 0
		nFaces = 0
		nTVerts = 0
		objname = "Object"

		first_obj = true			
		while ((eof fp) == false) do (
			curline = readLine fp
			string = filterString curline " :,\""
			linetype = rtoken curline

			case linetype of (
				"v": (
					nVerts += 1
					x = (string[2] as float)
					y = (string[3] as float)
					z = (string[4] as float)
					verts[nVerts] = [x,y,z]
				)
				"vt": (
					nTverts += 1
					u = (string[2] as float)
					v = (string[3] as float)
					tverts[nTVerts] = [u,v,0]
				)
				"f": (
					nFaces += 1
					buf = filterString string[2] "/"
					a = (buf[1] as integer)
					buf = filterString string[3] "/"
					b = (buf[1] as integer)
					buf = filterString string[4] "/"
					c = (buf[1] as integer)
					faces[nFaces] = [a,b,c]
					if string.count > 4 then (
						nFaces += 1
						buf = filterString string[5] "/"
						d = (buf[1] as integer)
						faces[nFaces] = [a,c,d]
					)
				)

				"g": (
					if( first_obj == true ) then (
						-- we don't run creatobj() until we hit our second object
						first_obj = false
						objname = string[2]
					) else (
						createobj()
						-- redefine the arrays
						verts = #()
						faces = #()
						tverts = #()
						normals = #()
						nVerts = 0
						nFaces = 0
						nTVerts = 0
						objname = string[2]
					)
				)
			)
		)
		close fp
		-- create the last object in the file
		createobj()
	)
)

fn fn_export=(
	for obj in geometry do (
		if ( (obj.primaryVisibility==on) AND (obj.ishidden==false) ) then (

			snapobj = snapshot obj;
			theMesh = getNodeByName (snapobj.name);

			-- print out name of this object
			format  "g %\n" theMesh.name

/*
			-- Cycle through all vertices in this mesh and print out their coordinates
			for i = 1 to (getNumVerts theMesh) do (
				v = getVert theMesh i;
				format "v % % %\n" v.x v.y v.z
				-- do the normals too
				v = getNormal theMesh i
				format "vn % % %\n" v.x v.y v.z
			)
*/
			channel = 1
			cur_tvert = 1
			cur_vert = 1
			for face = 1 to theMesh.numFaces do (
				theFace = getFace theMesh face;
				x = (theFace.x as integer);
				y = (theFace.y as integer);
				z = (theFace.z as integer);
				
				v = getVert theMesh x
				format "v % % %\n" v.x v.y v.z
				v = getVert theMesh y
				format "v % % %\n" v.x v.y v.z
				v = getVert theMesh z
				format "v % % %\n" v.x v.y v.z
				
				v = getNormal theMesh x
				format "vn % % %\n" v.x v.y v.z
				v = getNormal theMesh y
				format "vn % % %\n" v.x v.y v.z
				v = getNormal theMesh z
				format "vn % % %\n" v.x v.y v.z

				-- get the map face for this mesh face
				theTFace = meshop.getMapFace theMesh channel face
				-- get the UVW coordinates of each texture vertex
				tvx = meshop.getMapVert theMesh channel (theTFace.x as integer)
				tvy = meshop.getMapVert theMesh channel (theTFace.y as integer)
				tvz = meshop.getMapVert theMesh channel (theTFace.z as integer)

				format "vt % %\n" tvx[1] tvx[2]
				format "vt % %\n" tvy[1] tvy[2]
				format "vt % %\n" tvz[1] tvz[2]

				format "f "
				format "%/%/% " cur_vert cur_tvert cur_vert
				format "%/%/% " (cur_vert + 1) (cur_tvert + 1) (cur_vert + 1)
				format "%/%/%\n"(cur_vert + 2) (cur_tvert + 2) (cur_vert + 2)
				cur_tvert += 3
				cur_vert += 3
			)

			delete snapobj;
		)
	)
)

utility spread "OBJ Import/Export" (

	button bt_export "Export" width:140 height:35
	button bt_import "Import" width:140 height:35

	on bt_export pressed do (
		clearListener()
	  	fn_export()
	)

	on bt_import pressed do (
		fn_import()
	)
)
